#include "main.h"

// win is global because we use it outside of main
static Evas_Object *win = NULL;

static void
_cb_button_clicked(void *data EINA_UNUSED, // data set when cb added
                   Evas_Object *obj EINA_UNUSED, // obj the cb is for
                   void *event_info EINA_UNUSED) // event specific info
{ // this func called when button is clicked
  evas_object_del(win); // delete main win
}

EAPI_MAIN int
elm_main(int argc EINA_UNUSED, char **argv EINA_UNUSED)
{
  Evas_Object *o, *tb, *bg, *bt, *ic;

  // quit app when last window closed
  elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
  // set up things so we can at runtime find out app dir - provide compile
  // time values first that are used to base things off
  elm_app_compile_bin_dir_set(PACKAGE_BIN_DIR);
  elm_app_compile_lib_dir_set(PACKAGE_LIB_DIR);
  elm_app_compile_data_dir_set(PACKAGE_DATA_DIR);
  // change tmpl-bg.jpg as needed if you remove or rename this data file
  // some data file is needed to be found to verify data location
  elm_app_info_set(elm_main, "tmpl", "tmpl-bg.jpg");
  elm_app_data_dir_get(); // now just call a get to prepare it

  // boring standard window with pre-set up default bg
  // can use elm_win_add directly to not have a std bg and get full control
  win = o = elm_win_util_standard_add("Main", "Tmpl Title");
  // this win will delete itself if you prress close in title etc.
  // we don't need to here, but if we care we can listen to delete events
  // on objects and track this and set win to NULL.
  elm_win_autodel_set(o, EINA_TRUE);
    { // a table in the window
      tb = o = elm_table_add(win);
      // allow expansion AND fill parent area
      evas_object_size_hint_weight_set(o, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
      evas_object_size_hint_fill_set(o, EVAS_HINT_FILL, EVAS_HINT_FILL);
      // add this to the stack of indow resize objects (resized with win)
      elm_win_resize_object_add(win, o);
        { // background widget with a manually set min size
          bg = o = elm_bg_add(win);
          // allow expansion AND fill parent area
          evas_object_size_hint_weight_set(o, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
          evas_object_size_hint_fill_set(o, EVAS_HINT_FILL, EVAS_HINT_FILL);
          // bg widget dont se min size, like gridm, so we can do this
          // and set a manual min size (scaled)
          evas_object_size_hint_min_set(o, ELM_SCALE_SIZE(600), ELM_SCALE_SIZE(360));
          elm_table_pack(tb, o, 0, 0, 3, 3); // pack in table @ 0,0 3x3
          // MAGIC! beceause we did the elm_app_* calls above e can use vpath
          // to find where the app data is installed and use that dir in place
          // of (:app.data:). see eina_vpath.h for more magic dirs you can use!
          elm_bg_file_set(o, "(:app.data:)/tmpl-bg.jpg", NULL);
          evas_object_show(bg);
        }
        { // button at bottom-right to close things
          bt = o = elm_button_add(win);
          elm_object_text_set(o, "Close");
          // when button is clicked call _cb_button_clicked
          evas_object_smart_callback_add(o, "clicked", _cb_button_clicked, NULL);
          elm_table_pack(tb, o, 2, 2, 1, 1); // pack in table @ 2,2 1x1
            { // put an icon widget in the button widget with std icon
              ic = o = elm_icon_add(win);
              // many standard icons - look at icons.edc in default themet
              elm_icon_standard_set(o, "close");
              // make this icon widget the content of the button
              elm_object_content_set(bt, o);
              evas_object_show(ic);
            }
          evas_object_show(bt);
        }
      evas_object_show(tb);
    }
  evas_object_show(win);

  // run the main loop until done
  elm_run();

  return 0;
}
ELM_MAIN()
