#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

typedef struct
{
   struct 
     {
	float r;
	float g; /* 0 1 */
	float b; /* 2 3 */
     } pixel[4];
} pixelblock;

char shade_list[]={32,176,177,178,219}; /*   ,  ,  ,   ,  */
float shade_level[]={0,0.25,0.5,0.75,1.0};
char block_list[]={220,223,221,222}; /*  ,  ,  ,  */

#define SHADE0 0
#define SHADE1 1
#define SHADE2 2
#define SHADE3 3
#define SHADE4 4
#define BLOCK0 5
#define BLOCK1 6
#define BLOCK2 7
#define BLOCK3 8

float cr1[]={0   ,0.67,0   ,0.67,0   ,0.67,0   ,0.67};
float cg1[]={0   ,0   ,0.53,0.33,0   ,0   ,0.67,0.67};
float cb1[]={0   ,0   ,0   ,0.13,0.67,0.67,0.67,0.67};
float cr2[]={0   ,1   ,0.27,1   ,0.27,1   ,0.27,1   };
float cg2[]={0   ,0.27,1   ,1   ,0.27,0.27,1   ,1   };
float cb2[]={0   ,0.27,0.27,0.27,1   ,1   ,1   ,1   };

unsigned char *buf;
int width;
int height;

float chardiff(int c, pixelblock *p, int fg, int bg, int br)
{
   pixelblock pp;
   float dr,dg,db;
   float diff;
   int l;
   
   switch (c)
     {
      case SHADE0:
	l=0;
	if (br==0)
	  {
	     pp.pixel[0].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	else
	  {
	     pp.pixel[0].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	break;
      case SHADE1:
	l=1;
	if (br==0)
	  {
	     pp.pixel[0].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	else
	  {
	     pp.pixel[0].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	break;
      case SHADE2:
	l=2;
	if (br==0)
	  {
	     pp.pixel[0].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	else
	  {
	     pp.pixel[0].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	break;
      case SHADE3:
	l=3;
	if (br==0)
	  {
	     pp.pixel[0].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	else
	  {
	     pp.pixel[0].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	break;
      case SHADE4:
	l=4;
	if (br==0)
	  {
	     pp.pixel[0].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr1[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg1[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb1[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	else
	  {
	     pp.pixel[0].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[0].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[0].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[1].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[1].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[1].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[2].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[2].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[2].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	     pp.pixel[3].r=(cr2[fg]*(shade_level[l]))+(cr1[bg]*(1-shade_level[l]));
	     pp.pixel[3].g=(cg2[fg]*(shade_level[l]))+(cg1[bg]*(1-shade_level[l]));
	     pp.pixel[3].b=(cb2[fg]*(shade_level[l]))+(cb1[bg]*(1-shade_level[l]));
	  }
	break;
      case BLOCK0:
	if (br==0)
	  {
	     pp.pixel[0].r=cr1[bg];
	     pp.pixel[0].g=cg1[bg];
	     pp.pixel[0].b=cb1[bg];
	     pp.pixel[1].r=cr1[bg];
	     pp.pixel[1].g=cg1[bg];
	     pp.pixel[1].b=cb1[bg];
	     pp.pixel[2].r=cr1[fg];
	     pp.pixel[2].g=cg1[fg];
	     pp.pixel[2].b=cb1[fg];
	     pp.pixel[3].r=cr1[fg];
	     pp.pixel[3].g=cg1[fg];
	     pp.pixel[3].b=cb1[fg];
	  }
	else
	  {
	     pp.pixel[0].r=cr1[bg];
	     pp.pixel[0].g=cg1[bg];
	     pp.pixel[0].b=cb1[bg];
	     pp.pixel[1].r=cr1[bg];
	     pp.pixel[1].g=cg1[bg];
	     pp.pixel[1].b=cb1[bg];
	     pp.pixel[2].r=cr2[fg];
	     pp.pixel[2].g=cg2[fg];
	     pp.pixel[2].b=cb2[fg];
	     pp.pixel[3].r=cr2[fg];
	     pp.pixel[3].g=cg2[fg];
	     pp.pixel[3].b=cb2[fg];
	  }
	break;
      case BLOCK1:
	if (br==0)
	  {
	     pp.pixel[0].r=cr1[fg];
	     pp.pixel[0].g=cg1[fg];
	     pp.pixel[0].b=cb1[fg];
	     pp.pixel[1].r=cr1[fg];
	     pp.pixel[1].g=cg1[fg];
	     pp.pixel[1].b=cb1[fg];
	     pp.pixel[2].r=cr1[bg];
	     pp.pixel[2].g=cg1[bg];
	     pp.pixel[2].b=cb1[bg];
	     pp.pixel[3].r=cr1[bg];
	     pp.pixel[3].g=cg1[bg];
	     pp.pixel[3].b=cb1[bg];
	  }
	else
	  {
	     pp.pixel[0].r=cr2[fg];
	     pp.pixel[0].g=cg2[fg];
	     pp.pixel[0].b=cb2[fg];
	     pp.pixel[1].r=cr2[fg];
	     pp.pixel[1].g=cg2[fg];
	     pp.pixel[1].b=cb2[fg];
	     pp.pixel[2].r=cr1[bg];
	     pp.pixel[2].g=cg1[bg];
	     pp.pixel[2].b=cb1[bg];
	     pp.pixel[3].r=cr1[bg];
	     pp.pixel[3].g=cg1[bg];
	     pp.pixel[3].b=cb1[bg];
	  }
	break;
      case BLOCK2:
	if (br==0)
	  {
	     pp.pixel[0].r=cr1[fg];
	     pp.pixel[0].g=cg1[fg];
	     pp.pixel[0].b=cb1[fg];
	     pp.pixel[1].r=cr1[bg];
	     pp.pixel[1].g=cg1[bg];
	     pp.pixel[1].b=cb1[bg];
	     pp.pixel[2].r=cr1[fg];
	     pp.pixel[2].g=cg1[fg];
	     pp.pixel[2].b=cb1[fg];
	     pp.pixel[3].r=cr1[bg];
	     pp.pixel[3].g=cg1[bg];
	     pp.pixel[3].b=cb1[bg];
	  }
	else
	  {
	     pp.pixel[0].r=cr2[fg];
	     pp.pixel[0].g=cg2[fg];
	     pp.pixel[0].b=cb2[fg];
	     pp.pixel[1].r=cr1[bg];
	     pp.pixel[1].g=cg1[bg];
	     pp.pixel[1].b=cb1[bg];
	     pp.pixel[2].r=cr2[fg];
	     pp.pixel[2].g=cg2[fg];
	     pp.pixel[2].b=cb2[fg];
	     pp.pixel[3].r=cr1[bg];
	     pp.pixel[3].g=cg1[bg];
	     pp.pixel[3].b=cb1[bg];
	  }
	break;
      case BLOCK3:
	if (br==0)
	  {
	     pp.pixel[0].r=cr1[bg];
	     pp.pixel[0].g=cg1[bg];
	     pp.pixel[0].b=cb1[bg];
	     pp.pixel[1].r=cr1[fg];
	     pp.pixel[1].g=cg1[fg];
	     pp.pixel[1].b=cb1[fg];
	     pp.pixel[2].r=cr1[bg];
	     pp.pixel[2].g=cg1[bg];
	     pp.pixel[2].b=cb1[bg];
	     pp.pixel[3].r=cr1[fg];
	     pp.pixel[3].g=cg1[fg];
	     pp.pixel[3].b=cb1[fg];
	  }
	else
	  {
	     pp.pixel[0].r=cr1[bg];
	     pp.pixel[0].g=cg1[bg];
	     pp.pixel[0].b=cb1[bg];
	     pp.pixel[1].r=cr2[fg];
	     pp.pixel[1].g=cg2[fg];
	     pp.pixel[1].b=cb2[fg];
	     pp.pixel[2].r=cr1[bg];
	     pp.pixel[2].g=cg1[bg];
	     pp.pixel[2].b=cb1[bg];
	     pp.pixel[3].r=cr2[fg];
	     pp.pixel[3].g=cg2[fg];
	     pp.pixel[3].b=cb2[fg];
	  }
	break;
      default:
	break;
     }
   dr=p->pixel[0].r-pp.pixel[0].r;if (dr<0) dr=-dr;
   dg=p->pixel[0].g-pp.pixel[0].g;if (dg<0) dg=-dg;
   db=p->pixel[0].b-pp.pixel[0].b;if (db<0) db=-db;
   diff=dr+dg+db;
   dr=p->pixel[1].r-pp.pixel[1].r;if (dr<0) dr=-dr;
   dg=p->pixel[1].g-pp.pixel[1].g;if (dg<0) dg=-dg;
   db=p->pixel[1].b-pp.pixel[1].b;if (db<0) db=-db;
   diff+=dr+dg+db;
   dr=p->pixel[2].r-pp.pixel[2].r;if (dr<0) dr=-dr;
   dg=p->pixel[2].g-pp.pixel[2].g;if (dg<0) dg=-dg;
   db=p->pixel[2].b-pp.pixel[2].b;if (db<0) db=-db;
   diff+=dr+dg+db;
   dr=p->pixel[3].r-pp.pixel[3].r;if (dr<0) dr=-dr;
   dg=p->pixel[3].g-pp.pixel[3].g;if (dg<0) dg=-dg;
   db=p->pixel[3].b-pp.pixel[3].b;if (db<0) db=-db;
   diff+=dr+dg+db;
   return diff;
}

void chosechar(pixelblock *p, char *c, int *fg, int *bg, int *br)
{
   int f,b,h;
   float diff;
   float diff_max;
   char ch;
   
   diff_max=999999;
   for (h=0;h<2;h++)
     {
	for (b=0;b<8;b++)
	  {
	     for (f=0;f<8;f++)
	       {
		  diff=chardiff(SHADE0,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=shade_list[0];*fg=f;*bg=b;*br=h;}
		  diff=chardiff(SHADE1,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=shade_list[1];*fg=f;*bg=b;*br=h;}
		  diff=chardiff(SHADE2,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=shade_list[2];*fg=f;*bg=b;*br=h;}
		  diff=chardiff(SHADE3,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=shade_list[3];*fg=f;*bg=b;*br=h;}
		  diff=chardiff(SHADE4,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=shade_list[4];*fg=f;*bg=b;*br=h;}
		  diff=chardiff(BLOCK0,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=block_list[0];*fg=f;*bg=b;*br=h;}
		  diff=chardiff(BLOCK1,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=block_list[1];*fg=f;*bg=b;*br=h;}
		  diff=chardiff(BLOCK2,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=block_list[2];*fg=f;*bg=b;*br=h;}
		  diff=chardiff(BLOCK3,p,f,b,h);
		  if (diff<diff_max) {diff_max=diff;ch=block_list[3];*fg=f;*bg=b;*br=h;}
	       }
	  }
     }
   *c=ch;
}

loadppm(char *name)
{
   FILE *f;
   unsigned char s[256],ss[256];
   int done;
   
   buf=0;
   f=fopen(name,"r");  
   if (!f) 
     {
	fprintf(stderr,"Unable to load file %s\n",name);
	buf=0;return;
     }
   if (!fgets(s,256,f))
     {
	fprintf(stderr,"Error reading header of file %s\n",name);
	fclose(f);
	buf=0;return;
     }
   sscanf(s,"%s",ss);
   if (!strcmp(ss,"P6"))
     {
	done=1;
	while (done)
	  {
	     if (!fgets(s,256,f))
	       {
		  fprintf(stderr,"Error reading header line of file %s\n",name);
		  fclose(f);
		  buf=0;return;
	       }
	     if (s[0]!='#')      
	       {
		  sscanf(s,"%i %i",&width,&height);
		  if (!fgets(s,256,f))
		    {
		       fprintf(stderr,"Error reading header line of file %s\n",name);
		       fclose(f);
		       buf=0;return;
		    }
		  if (!(buf=malloc(width*height*3)))
		    {
		       fprintf(stderr,"Error allocating RAM for file %s\n",name);
		       fclose(f);
		       buf=0;return;
		    }
		  if (!fread(buf,width*height*3,1,f))
		    {
		       fprintf(stderr,"Error reading image data from file %s\n",name);
		       fclose(f);
		       free(buf);
		       buf=0;return;
		    }
		  done=0;
	       }
	  }
     }
   else
     {
	fprintf(stderr,"Error, file %s is not a BINARY PPM file\n",name);
	fclose(f);
	buf=0;return;
     }
   fclose(f);
}

void convertppm()
{
   int x,y;
   pixelblock p;
   char c;
   int pfg,pbg,pbr;
   int fg,bg,br;
   int numdun;
   
   for (y=0;y<height;y+=2)
     {
	pfg=-1;pbg=-1;pbr=-1;
	for(x=0;x<width;x+=2)
	  {
	     p.pixel[0].r=(float)buf[((((y+0)*width)+(x+0))*3)+0]/255;
	     p.pixel[0].g=(float)buf[((((y+0)*width)+(x+0))*3)+1]/255;
	     p.pixel[0].b=(float)buf[((((y+0)*width)+(x+0))*3)+2]/255;
	     p.pixel[1].r=(float)buf[((((y+0)*width)+(x+1))*3)+0]/255;
	     p.pixel[1].g=(float)buf[((((y+0)*width)+(x+1))*3)+1]/255;
	     p.pixel[1].b=(float)buf[((((y+0)*width)+(x+1))*3)+2]/255;
	     p.pixel[2].r=(float)buf[((((y+1)*width)+(x+0))*3)+0]/255;
	     p.pixel[2].g=(float)buf[((((y+1)*width)+(x+0))*3)+1]/255;
	     p.pixel[2].b=(float)buf[((((y+1)*width)+(x+0))*3)+2]/255;
	     p.pixel[3].r=(float)buf[((((y+1)*width)+(x+1))*3)+0]/255;
	     p.pixel[3].g=(float)buf[((((y+1)*width)+(x+1))*3)+1]/255;
	     p.pixel[3].b=(float)buf[((((y+1)*width)+(x+1))*3)+2]/255;
	     chosechar(&p,&c,&fg,&bg,&br);
	     if ((pfg!=fg)||(pbg!=bg)||(pbr!=br))
	       {
		  numdun=0;
		  printf("%c[",27);
		  if (pbr!=br) 
		    {
		       printf("%i",br);
		       pfg=-1;
		       if (br==0) pbg=-1;
		       numdun=1;
		    }
		  if (pfg!=fg) 
		    {
		       if (numdun) printf(";");
		       printf("%i",30+fg);
		       numdun=1;
		    }
		  if (pbg!=bg) 
		    {
		       if (numdun) printf(";");
		       printf("%i",40+bg);
		    }
		  printf("m");
	       }
	     pfg=fg;pbg=bg;pbr=br;
	     printf("%c",c);
	  }
	printf("%c[0m\n",27);
     }
   free(buf);
}

main(int argc,char **argv)
{
   int i;
   
   if (argc<2)
     {
	fprintf(stderr,"Usage:\n\t%s file1.ppm [file2.ppm] [file3.ppm] ...\n",
		argv[0]);
	exit(1);
     }
   for (i=1;i<argc;i++)
     {
	loadppm(argv[i]);
	if (buf) convertppm();
     }
}



