#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* public header */
typedef struct obj_t obj_t;
typedef struct pub_t pub_t;
struct pub_t {
   pub_t *(*create)   (void);
   void   (*destroy)  (pub_t *obj);
   void   (*set_text) (pub_t *obj, char *text);
};
struct obj_t {
   pub_t pub;
   char *text;
};
/* private implementation */
pub_t *obj_create(void);
void   obj_destroy(pub_t *obj);
void   obj_set_text(pub_t *obj, char *text);
pub_t klass = {
   obj_create,
   obj_destroy,
   obj_set_text
};
pub_t *obj_create(void) {
   obj_t *o = calloc(1, sizeof(obj_t));
   o->pub = klass;
   return &(o->pub);
}
void obj_destroy(pub_t *obj) {
   obj_t *o = (obj_t *)obj;
   free(o->text);
   free(o);
}
void obj_set_text(pub_t *obj, char *text) {
   obj_t *o = (obj_t *)obj;
   free(o->text);
   o->text = strdup(text);
}
/* in use */
int main(int argc, char **argv) {
   pub_t *obj = klass.create();
   obj->set_text(obj, "hello");
   obj->destroy(obj);
}
